USE [ProSolutionReports]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE VIEW [vOG_2526_QOE]
AS

------------------------------------------------
--QOE Import Template for OneGrade VA
------------------------------------------------

SELECT
SD.AcademicYearID,				--*UniqueKey
SD.RefNo,						--*UniqueKey
PLRLED.SourceQualificationCode,	--*UniqueKey
PLRLED.QualificationTitle,
PLRLED.grade,
PLRLED.AwardDate

FROM
ProSolution.dbo.PLRDownload PLRD with (nolock)
	INNER JOIN ProSolution.dbo.PLRLearnerEventDownload PLRLED with (nolock)
	ON PLRD.PLRDownloadID = PLRLED.PLRDownloadID
		INNER JOIN ProSolution.dbo.StudentDetail SD with (nolock)
		ON PLRD.StudentID = SD.StudentID
			INNER JOIN ProSolution.dbo.Learning_Aim LA with (nolock)
			ON LA.LEARNING_AIM_REF = PLRLED.SourceQualificationCode
				INNER JOIN
					(
					SELECT 
						MAX(PLRLEDM.PLRLearnerEventDownloadID) AS MaxPLRLearnerEventDownloadID
					FROM
						ProSolution.dbo.PLRLearnerEventDownload PLRLEDM with (nolock)
					GROUP BY
						PLRLEDM.PLRDownloadID, PLRLEDM.SourceQualificationCode
					) MaxPRLED
				ON PLRLED.PLRLearnerEventDownloadID = MaxPRLED.MaxPLRLearnerEventDownloadID
					--Refer back to the vOG_2526_Students to only return QOE for the Students being Imported.
					INNER JOIN vOG_2526_Student WITH (NOLOCK)
						ON vOG_2526_Student.AcademicYearID = SD.AcademicYearID
						AND vOG_2526_Student.LearnerRef = SD.RefNo

WHERE     
	SD.AcademicYearID = '25/26' 
	AND LA.NOTIONAL_NVQ_LEVEL_CODE = '2'								--Level 2 Qual
	AND ISNULL(PLRLED.Grade,'') <> ''									--Only where we have a grade
	AND (PLRLED.AwardDate IS NULL OR PLRLED.AwardDate < '2025/10/01')	--Only where Quals are awarded before Oct 1 2025
																		--(Allows for Awards issued in August/Sept 2025 prior to start in AcYr 25/26 - due to delays in results allow Aug + Sept)



GO